function MeshMaker
% MESHMAKER assists in creating FE beam model based on voxel images
% obtained from automatic tile desing procedure

% ACCEPT MY GREAT APOLOGY FOR CZECH LANGUAGE WITHIN THE SCRIPT
% HOWEVER, BASIC FUNCTIONALITY IS DESCRIBED IN PROVIDED README.TXT FILE

%
% === LOG ZMN ===
% - vychz z verze Bedrich.m, upraveno pro pouit na Wangovy dladice
% - nastaveno zobrazovn kd dladice, pidna tlatka pro naten a uloen geometrie na hranicch
% - limity byly nahrazeny velikost dladice, zaokrouhlovn na pesnost zstalo
% - vypisovn skutench koordint pi pohybu my, kter budou uloeny (na zklad zadan velikosti dladice)
% - tlatko na pidn linie zstv (pidv na posledn dva definovan body)
% - pidno natn dlch geometri na hranch (umonno nejdve jen nast, pokud nen nalezena geometrie, sm se nov uloit)
% - naitn a ukldn geometrie cel dladice (vetn uloen a naten geometrick velikosti a pesnosti)
%
% === TODO LIST ===
% ? najt zpsob pro lep zadvn prut
% ? umonit vymazvat body a linie (ale asi ne pro hranin prvky)
% ? pidat vt "blbuvzdornost" (nap. nyn lze pepisovat geometrii hran neustle, stejn jako geometrii cel dladice)
% ? umonit vymazn veho a zat s novou bitmapou (pravdpodobn napojit na natn bitmapy)
% ? drag-and-drop posouvn bod
%
% === NVOD K POUIT ===
% 1 nast grafick ztvrnn
% 2 pokusit se nast geometrii na hranch
% 3 naklikat geometrii
% 4 uloit geometrii a ppadn i geometrii na hranch
% 5 vypnout/zapnout a pokraovat na dal dladici
%
% !!! POZOR NA MIMA V SOUADNICCH A JEJICH SMRECH !!! ( pro vykreslovn plat x_vykr=y_uloz a y_vykr=x_uloz, proto jsou pehozeny indexy 1 a 2)

%% definice jednotlivch prvk GUI
fig = figure('Visible','off','Position',[0 0 800 640],'Unit','pixels','Color',[0.94 0.94 0.94],'ToolBar','none','MenuBar','none','Resize','on','WindowButtonMotionFcn',{@Myseni},'WindowButtonDownFcn',{@UlozBod});
tlNacist = uicontrol('Parent',fig, 'Style','Pushbutton', 'String','Nast grafiku', 'Position',[675 608 100 25], 'Callback',{@NactiObrazek});
edSoubor = uicontrol('Parent',fig, 'Style','Edit', 'String','Pro naten grafick reprezentace Wangovy dladice pouijte tlatko "Nast grafiku".', 'HorizontalAlignment','center', 'Position',[50 610 620 20]);
txW = uicontrol('Parent',fig,'Style','Text','String','W:','FontSize',12,'HorizontalAlignment','left','Position',[50 570 20 20]);
edW = uicontrol('Parent',fig,'Style','Edit','String','0','HorizontalAlignment','left','Position',[70 570 20 20]);
tlWload = uicontrol('Parent',fig,'Style','Pushbutton','String','Nast','Position',[95 568 50 25],'Callback',{@NactiW});
tlWsave = uicontrol('Parent',fig,'Style','Pushbutton','String','Uloit','Position',[150 568 50 25],'Enable','off','Callback',{@UlozW});
txN = uicontrol('Parent',fig,'Style','Text','String','N:','FontSize',12,'HorizontalAlignment','left','Position',[240 570 20 20]);
edN = uicontrol('Parent',fig,'Style','Edit','String','0','HorizontalAlignment','left','Position',[260 570 20 20]);
tlNload = uicontrol('Parent',fig,'Style','Pushbutton','String','Nast','Position',[285 568 50 25],'Callback',{@NactiN});
tlNsave = uicontrol('Parent',fig,'Style','Pushbutton','String','Uloit','Position',[340 568 50 25],'Enable','off','Callback',{@UlozN});
txE = uicontrol('Parent',fig,'Style','Text','String','E:','FontSize',12,'HorizontalAlignment','left','Position',[430 570 20 20]);
edE = uicontrol('Parent',fig,'Style','Edit','String','0','HorizontalAlignment','left','Position',[450 570 20 20]);
tlEload = uicontrol('Parent',fig,'Style','Pushbutton','String','Nast','Position',[475 568 50 25],'Callback',{@NactiE});
tlEsave = uicontrol('Parent',fig,'Style','Pushbutton','String','Uloit','Position',[530 568 50 25],'Enable','off','Callback',{@UlozE});
txS = uicontrol('Parent',fig,'Style','Text','String','S:','FontSize',12,'HorizontalAlignment','left','Position',[620 570 20 20]);
edS = uicontrol('Parent',fig,'Style','Edit','String','0','HorizontalAlignment','left','Position',[640 570 20 20]);
tlSload = uicontrol('Parent',fig,'Style','Pushbutton','String','Nast','Position',[665 568 50 25],'Callback',{@NactiS});
tlSsave = uicontrol('Parent',fig,'Style','Pushbutton','String','Uloit','Position',[720 568 50 25],'Enable','off','Callback',{@UlozS});
axPlatno = axes('Parent',fig,'Units','Pixels','Visible','on','Box','on','LineStyleOrder',{'-'},'Position',[275 50 500 500]);
tabBody = uitable(fig,'Data',[],'ColumnName',{'X' 'Y'},'ColumnWidth',{70 70},'Position',[35 350 205 200],'CellEditCallback',{@AktualizujBody},'ColumnEditable',[true true]);
txRozmer = uicontrol('Parent',fig,'Style','Text','String','Rozmr:','HorizontalAlignment','left','Position',[35 317 40 20]);
edRozmer= uicontrol('Parent',fig,'Style','Edit','String','1','BackgroundColor','White','HorizontalAlignment','left','Position',[80 320 50 20],'Callback',{@AktualizujRozmer});
txPresnost = uicontrol('Parent',fig,'Style','Text','String','Pesnost:','HorizontalAlignment','left','Position',[140 317 50 20]);
edPresnost= uicontrol('Parent',fig,'Style','Edit','String','0.01','BackgroundColor','White','HorizontalAlignment','left','Position',[190 320 50 20],'Callback',{@AktualizujPresnost});
tabLinie = uitable(fig,'Data',[],'ColumnName',{'Potek' 'Konec'},'ColumnWidth',{70 70},'Position',[35 100 205 200],'CellEditCallback',{@AktualizujLinie},'ColumnEditable',[true true]);
tlPridatLinii = uicontrol('Style','Pushbutton','String','Pidat linii','Position',[35 70 100 20],'Callback',{@PridatLinii});
tlNacist = uicontrol('Style','Pushbutton','String','Nast geometrii','Position',[35 25 100 25],'Callback',{@NactiGeometrii});
tlUlozit = uicontrol('Style','Pushbutton','String','Uloit geometrii','Position',[140 25 100 25],'Callback',{@UlozGeometrii});
txXcoor = uicontrol('Parent',fig,'Style','Text','String','x coordinate:','HorizontalAlignment','left','Position',[160 0 390 15]);
txYcoor = uicontrol('Parent',fig,'Style','Text','String','y coordinate:','HorizontalAlignment','left','Position',[410 0 390 15]);

%% inicializace promnnch a samotnho GUI
movegui(fig,'center');
setappdata(fig,'soubor',[]);
setappdata(fig,'adresar',[]);
setappdata(fig,'nazev',[]);
setappdata(fig,'W',[]);
setappdata(fig,'N',[]);
setappdata(fig,'E',[]);
setappdata(fig,'S',[]);
setappdata(fig,'pocetBodu',0);
setappdata(fig,'pocetLinii',0);
setappdata(fig,'listBodu',[]);
setappdata(fig,'listLinii',[]);
setappdata(fig,'rozmer',1);
setappdata(fig,'presnost',0.01);
setappdata(fig,'dPixelu',1);
set(fig,'Visible','on');

%% definice funkc
    function Myseni(hObject,eventdata)
        souradniceMysi=get(fig,'CurrentPoint');
        x=souradniceMysi(1);
        y=souradniceMysi(2);
        souradnicePlatna=get(axPlatno,'Position');
        px=souradnicePlatna(1);
        py=souradnicePlatna(2);
        dx=souradnicePlatna(3);
        dy=souradnicePlatna(4);
        if x>=px+1 && x<=(px+dx) && y>=py+1 && y<=(py+dy)
            presnost=getappdata(fig,'presnost');
            rozmer=getappdata(fig,'rozmer');
            ax=(x-px)./dx;
            ay=1-(y-py)./dy;
            ax=round(ax./presnost).*presnost.*rozmer;
            ay=round(ay./presnost).*presnost.*rozmer;
            set(txXcoor,'String',['x coordinate: ',num2str(x),' [',num2str(ay),']']);
            set(txYcoor,'String',['y coordinate: ',num2str(y),' [',num2str(ax),']']);
        else
            set(txXcoor,'String',['x coordinate: ',num2str(x),' [-]']);
            set(txYcoor,'String',['y coordinate: ',num2str(y),' [-]']);
        end;
    end

    function NactiObrazek(hObject,eventdata)
        [soubor adresar]=uigetfile({'*.png'},'FileSelector');
        if soubor~=0
            [W statusW]=str2num(soubor(1));
            [N statusN]=str2num(soubor(2));
            [E statusE]=str2num(soubor(3));
            [S statusS]=str2num(soubor(4));
            if ~statusW || ~statusN || ~statusE || ~statusS || strcmpi(soubor(5:8),'-png')
                msgbox('Formt vstupnho grafickho souboru je nestandarsn. Nkter funkce nemus fungovat. Prosm, pejmenujte vstupn soubor na tvar "WNES.wtf".','Upozornn','warn');
            else
                setappdata(fig,'soubor',soubor);
                setappdata(fig,'nazev',soubor(1:4));
                setappdata(fig,'adresar',adresar);
                setappdata(fig,'W',W); set(edW,'String',W);
                setappdata(fig,'N',N); set(edN,'String',N);
                setappdata(fig,'E',E); set(edE,'String',E);
                setappdata(fig,'S',S); set(edS,'String',S);
                iptsetpref('ImshowAxesVisible','on');
                %iptsetpref('ImshowBorder','tight');
                img=imread(strcat(getappdata(fig,'adresar'),getappdata(fig,'soubor')));
                setappdata(fig,'dPixelu',size(img,1));
                set(edSoubor,'String',strcat(getappdata(fig,'adresar'),getappdata(fig,'soubor')));
                imshow(img,'Parent',axPlatno);
                Vykresli;
            end;
        end;
    end

    function NactiGeometrii(hObject,eventdata)
        [soubor adresar]=uigetfile({'*.wtg'},['Nati geometrii Wangovy dladice ',num2str(getappdata(fig,'W')),num2str(getappdata(fig,'N')),num2str(getappdata(fig,'E')),num2str(getappdata(fig,'S'))],strcat(getappdata(fig,'adresar'),getappdata(fig,'nazev'),'.wtg'));
        if soubor~= 0
            souborID=fopen(strcat(adresar,soubor),'r');
            fscanf(souborID,'TOPOLOGIE WANGOVY DLADICE %s\n');
            pocetBodu=fscanf(souborID,'nodes: %i\n',1);
            pocetLinii=fscanf(souborID,'lines: %i\n\nnode\tx\ty\n',1);
            listBodu=zeros(pocetBodu,2);
            listLinii=zeros(pocetLinii,2);
            for i=1:pocetBodu
                listBodu(i,:)=fscanf(souborID,'%*i\t%f\t%f\n',2);
            end;
            fscanf(souborID,'\nline\ta\tb\n');
            for i=1:pocetLinii
                listLinii(i,:)=fscanf(souborID,'%*i\t%i\t%i\n',2);
            end;
            fscanf(souborID,'\r\nRozmr\tPesnost\r\n');
            rozmer=fscanf(souborID,'%f\t',1);
            presnost=fscanf(souborID,'%f\t',1);
            fclose(souborID);
            setappdata(fig,'pocetBodu',pocetBodu);
            setappdata(fig,'pocetLinii',pocetLinii);
            setappdata(fig,'listBodu',listBodu);
            setappdata(fig,'listLinii',listLinii);
            set(tabBody,'Data',listBodu);
            set(tabLinie,'Data',listLinii);
            setappdata(fig,'rozmer',rozmer);
            set(edRozmer,'String',rozmer);
            setappdata(fig,'presnost',presnost);
            set(edPresnost,'String',presnost);
            Vykresli;
        end;
    end

    function UlozGeometrii(hObject,eventdata)
        [soubor adresar]=uiputfile({'*.wtg'},'Ulo geometrii',strcat(getappdata(fig,'adresar'),getappdata(fig,'nazev'),'.wtg'));
        if soubor~=0
            pocetBodu=getappdata(fig,'pocetBodu');
            pocetLinii=getappdata(fig,'pocetLinii');
            listBodu=getappdata(fig,'listBodu');
            listLinii=getappdata(fig,'listLinii');
            souborID=fopen(strcat(adresar,soubor),'w');
            fprintf(souborID,'TOPOLOGIE WANGOVY DLADICE %i%i%i%i\r\n',getappdata(fig,'W'),getappdata(fig,'N'),getappdata(fig,'E'),getappdata(fig,'S'));
            fprintf(souborID,'nodes:\t%i\r\n',pocetBodu);
            fprintf(souborID,'lines:\t%i\r\n',pocetLinii);
            fprintf(souborID,'\r\nnode\tx\ty\r\n');
            fprintf(souborID,'%i\t%f\t%f\r\n',[(1:pocetBodu)',listBodu]');
            fprintf(souborID,'\r\nline\ta\tb\r\n');
            fprintf(souborID,'%i\t%i\t%i\r\n',[(1:pocetLinii)',listLinii]');
            fprintf(souborID,'\r\nRozmr\tPesnost\r\n');
            fprintf(souborID,'%f\t%f',getappdata(fig,'rozmer'),getappdata(fig,'presnost'));
            fclose(souborID);
        end;
    end

    function NactiW(hObject,eventdata)        
        [souborID status]=fopen(strcat('ver',num2str(getappdata(fig,'W')),'.wtc'),'r');
        if isempty(status)
            pocetBodu=getappdata(fig,'pocetBodu');
            listBodu=getappdata(fig,'listBodu');
            fscanf(souborID,'SOUADNICE BODU NA VERTIKLN HRAN S KDOVM SLEM %i\r\n',1);
            pocetNovychBodu=fscanf(souborID,'nodes:\t%i\r\n\r\n',1);
            noveBody=ones(pocetNovychBodu,2).*0;
            for i=1:pocetNovychBodu
                noveBody(i,1)=fscanf(souborID,'%f\r\n',1);
            end;
            setappdata(fig,'listBodu',[getappdata(fig,'listBodu');noveBody]);
            setappdata(fig,'pocetBodu',pocetBodu+pocetNovychBodu);
            set(tabBody,'Data',getappdata(fig,'listBodu'));
            fclose(souborID);
            Vykresli;
        else
            msgbox('Geometrie bod pro tento kd na hran jet nebyla definovna. Definujte ji a nsledn ji ulote.','Upozornn','warn');
            set(tlWsave,'Enable','on');
        end;
        set(tlWload,'Enable','off');
    end
    
    function UlozW(hObject,eventdata)
        listBodu=getappdata(fig,'listBodu');
        indexy = find( listBodu(:,2)==0 );
        souborID=fopen(strcat('ver',num2str(getappdata(fig,'W')),'.wtc'),'w');
        fprintf(souborID,'SOUADNICE BODU NA VERTIKLN HRAN S KDOVM SLEM %i\r\n',getappdata(fig,'W'));
        fprintf(souborID,'nodes:\t%i\r\n\r\n',size(indexy,1));
        fprintf(souborID,'%f\r\n',listBodu(indexy,1));
        fclose(souborID);
    end

    function NactiN(hObject,eventdata)        
        [souborID status]=fopen(strcat('hor',num2str(getappdata(fig,'N')),'.wtc'),'r');
        if isempty(status)
            pocetBodu=getappdata(fig,'pocetBodu');
            listBodu=getappdata(fig,'listBodu');
            fscanf(souborID,'SOUADNICE BODU NA HORIZONTLN HRAN S KDOVM SLEM %i\r\n',1);
            pocetNovychBodu=fscanf(souborID,'nodes:\t%i\r\n\r\n',1);
            noveBody=ones(pocetNovychBodu,2).*0;
            for i=1:pocetNovychBodu
                noveBody(i,2)=fscanf(souborID,'%f\r\n',1);
            end;
            setappdata(fig,'listBodu',[getappdata(fig,'listBodu');noveBody]);
            setappdata(fig,'pocetBodu',pocetBodu+pocetNovychBodu);
            set(tabBody,'Data',getappdata(fig,'listBodu'));
            fclose(souborID);
            Vykresli;
        else
            msgbox('Geometrie bod pro tento kd na hran jet nebyla definovna. Definujte ji a nsledn ji ulote.','Upozornn','warn');
            set(tlNsave,'Enable','on');
        end;
        set(tlNload,'Enable','off');
    end
    
    function UlozN(hObject,eventdata)
        listBodu=getappdata(fig,'listBodu');
        indexy = find( listBodu(:,1)==0 );
        souborID=fopen(strcat('hor',num2str(getappdata(fig,'N')),'.wtc'),'w');
        fprintf(souborID,'SOUADNICE BODU NA HORIZONTLN HRAN S KDOVM SLEM %i\r\n',getappdata(fig,'N'));
        fprintf(souborID,'nodes:\t%i\r\n\r\n',size(indexy,1));
        fprintf(souborID,'%f\r\n',listBodu(indexy,2));
        fclose(souborID);
    end

    function NactiE(hObject,eventdata)        
        [souborID status]=fopen(strcat('ver',num2str(getappdata(fig,'E')),'.wtc'),'r');
        if isempty(status)
            pocetBodu=getappdata(fig,'pocetBodu');
            listBodu=getappdata(fig,'listBodu');
            rozmer=getappdata(fig,'rozmer');
            fscanf(souborID,'SOUADNICE BODU NA VERTIKLN HRAN S KDOVM SLEM %i\r\n',1);
            pocetNovychBodu=fscanf(souborID,'nodes:\t%i\r\n\r\n',1);
            noveBody=ones(pocetNovychBodu,2).*rozmer;
            for i=1:pocetNovychBodu
                noveBody(i,1)=fscanf(souborID,'%f\r\n',1);
            end;
            setappdata(fig,'listBodu',[getappdata(fig,'listBodu');noveBody]);
            setappdata(fig,'pocetBodu',pocetBodu+pocetNovychBodu);
            set(tabBody,'Data',getappdata(fig,'listBodu'));
            fclose(souborID);
            Vykresli;
        else
            msgbox('Geometrie bod pro tento kd na hran jet nebyla definovna. Definujte ji a nsledn ji ulote.','Upozornn','warn');
            set(tlEsave,'Enable','on');
        end;
        set(tlEload,'Enable','off');
    end
    
    function UlozE(hObject,eventdata)
        listBodu=getappdata(fig,'listBodu');
        rozmer=getappdata(fig,'rozmer');
        indexy = find( listBodu(:,2)==rozmer );
        souborID=fopen(strcat('ver',num2str(getappdata(fig,'E')),'.wtc'),'w');
        fprintf(souborID,'SOUADNICE BODU NA VERTIKLN HRAN S KDOVM SLEM %i\r\n',getappdata(fig,'E'));
        fprintf(souborID,'nodes:\t%i\r\n\r\n',size(indexy,1));
        fprintf(souborID,'%f\r\n',listBodu(indexy,1));
        fclose(souborID);
    end

    function NactiS(hObject,eventdata)        
        [souborID status]=fopen(strcat('hor',num2str(getappdata(fig,'S')),'.wtc'),'r');
        if isempty(status)
            pocetBodu=getappdata(fig,'pocetBodu');
            listBodu=getappdata(fig,'listBodu');
            rozmer=getappdata(fig,'rozmer');
            fscanf(souborID,'SOUADNICE BODU NA HORIZONTLN HRAN S KDOVM SLEM %i\r\n',1);
            pocetNovychBodu=fscanf(souborID,'nodes:\t%i\r\n\r\n',1);
            noveBody=ones(pocetNovychBodu,2).*rozmer;
            for i=1:pocetNovychBodu
                noveBody(i,2)=fscanf(souborID,'%f\r\n',1);
            end;
            setappdata(fig,'listBodu',[getappdata(fig,'listBodu');noveBody]);
            setappdata(fig,'pocetBodu',pocetBodu+pocetNovychBodu);
            set(tabBody,'Data',getappdata(fig,'listBodu'));
            fclose(souborID);
            Vykresli;
        else
            msgbox('Geometrie bod pro tento kd na hran jet nebyla definovna. Definujte ji a nsledn ji ulote.','Upozornn','warn');
            set(tlSsave,'Enable','on');
        end;
        set(tlSload,'Enable','off');
    end
    
    function UlozS(hObject,eventdata)
        listBodu=getappdata(fig,'listBodu');
        rozmer=getappdata(fig,'rozmer');
        indexy = find( listBodu(:,1)==rozmer );
        souborID=fopen(strcat('hor',num2str(getappdata(fig,'S')),'.wtc'),'w');
        fprintf(souborID,'SOUADNICE BODU NA HORIZONTLN HRAN S KDOVM SLEM %i\r\n',getappdata(fig,'S'));
        fprintf(souborID,'nodes:\t%i\r\n\r\n',size(indexy,1));
        fprintf(souborID,'%f\r\n',listBodu(indexy,2));
        fclose(souborID);
    end

    function Vykresli
        pocetBodu=getappdata(fig,'pocetBodu');
        pocetLinii=getappdata(fig,'pocetLinii');
        listBodu=getappdata(fig,'listBodu');
        listLinii=getappdata(fig,'listLinii');
        dPixelu=getappdata(fig,'dPixelu');
        rozmer=getappdata(fig,'rozmer');
        imshow(strcat(getappdata(fig,'adresar'),getappdata(fig,'soubor')),'Parent',axPlatno);
        imshow(strcat(getappdata(fig,'adresar'),getappdata(fig,'soubor')),'Parent',axPlatno);
        hold on
        if pocetBodu>0
            plot(listBodu(:,2).*dPixelu./rozmer,listBodu(:,1).*dPixelu./rozmer,'x','MarkerEdgeColor','m','MarkerFaceColor','r','MarkerSize',10);
            for i=1:pocetBodu
                text((listBodu(i,2)+0.01).*dPixelu./rozmer,(listBodu(i,1)-0.01).*dPixelu./rozmer,num2str(i),'HorizontalAlignment','left','VerticalAlignment','bottom','FontSize',12,'Color','m');
            end;
            for i=1:pocetLinii
                plot(listBodu(listLinii(i,:),2).*dPixelu./rozmer,listBodu(listLinii(i,:),1).*dPixelu./rozmer,'m')
            end;
        end;
        hold off
    end

    function UlozBod(hObject,eventdata)
        souradniceMysi=get(fig,'CurrentPoint');
        x=souradniceMysi(1);
        y=souradniceMysi(2);
        souradnicePlatna=get(axPlatno,'Position');
        px=souradnicePlatna(1);
        py=souradnicePlatna(2);
        dx=souradnicePlatna(3);
        dy=souradnicePlatna(4);
        if x>=px+1 && x<=(px+dx) && y>=py+1 && y<=(py+dy)
            % transformace souadnic
            presnost=getappdata(fig,'presnost');
            rozmer=getappdata(fig,'rozmer');
            listBodu=getappdata(fig,'listBodu');
            ax=(x-px)/dx;
            ay=1-(y-py)/dy;
            ax=round(ax*rozmer/presnost)*presnost;
            ay=round(ay*rozmer/presnost)*presnost;
            listBodu=[listBodu;ay ax];
            set(tabBody,'Data',listBodu);
            setappdata(fig,'listBodu',listBodu);
            setappdata(fig,'pocetBodu',getappdata(fig,'pocetBodu')+1);
            Vykresli;
        end;
    end
   
    function PridatLinii(hObject,eventdata)
        pocetBodu=getappdata(fig,'pocetBodu');
        pocetLinii=getappdata(fig,'pocetLinii');
        listLinii=getappdata(fig,'listLinii');
        if pocetBodu>0
            pocetLinii=pocetLinii+1;
            listLinii=[listLinii; max(1,pocetBodu-1) pocetBodu];
            setappdata(fig,'pocetLinii',pocetLinii);
            setappdata(fig,'listLinii',listLinii);
            set(tabLinie,'Data',listLinii);
            Vykresli;
        end;
    end

    function AktualizujBody(hObject,eventdata)
        listBoduN=get(tabBody,'Data');
        rozmer=getappdata(fig,'rozmer');
        if min(min(listBoduN>=0 & listBoduN<=rozmer))
            setappdata(fig,'listBodu',listBoduN);
        else
            set(tabBody,'Data',getappdata(fig,'listBodu'));
        end;
        Vykresli;
    end

    function AktualizujLinie(hObject,eventdata)
        listLiniiN=get(tabLinie,'Data');
        pocetBodu=getappdata(fig,'pocetBodu');
        if min(min(listLiniiN>=1 & listLiniiN<=pocetBodu))
            setappdata(fig,'listLinii',listLiniiN);
        else
            set(tabLinie,'Data',getappdata(fig,'listLinii'));
        end;
        Vykresli;
    end

    function AktualizujPresnost(hObject,eventdata)
        [presnost kontrola]=str2num(get(edPresnost,'String'));
        if kontrola
            setappdata(fig,'presnost',presnost);
        end;
    end

    function AktualizujRozmer(hObject,eventdata)
        [rozmerN kontrola]=str2num(get(edRozmer,'String'));
        if kontrola
            rozmerS=getappdata(fig,'rozmer');
            listBoduS=getappdata(fig,'listBodu');
            listBoduN=listBoduS./rozmerS.*rozmerN;
            setappdata(fig,'rozmer',rozmerN);
            setappdata(fig,'listBodu',listBoduN);
            set(tabBody,'Data',listBoduN);
        end;
        Vykresli;
    end

end